<?php
@session_start();
include ("setting.php");
class Product_type{
	public $id;
	public $name;
	public $category = array();
}
class Product_category{
	public $id;
	public $type_id;
	public $category_name;
	public $category_val;
	public $sub_category = array();

}

class Product_sub_category{
	public $id;
	public $category_name;
	public $sub_category_name ;

}
class Product{
	public $id;
	public $product_code;
	public $product_name;
	public $product_desc;
	public $product_price_srp;
	public $product_price_tech;
	public $product_img;
	public $product_warranty;
	public $link;
}

class Products{
	private $conn = null;
	function __construct(){
		$db = new DB();
		$this->conn = $db->DBConnect();
	}
	public function getHTML($category,$sub_category,$skip,$take){
		$post = [
		    'pd_type' => 'product',
		    'category_data[0][main_menu]' => $category,
		    'skip' => $skip,
		    'menu_level'   => 2,
		    'take' => $take
		];
		if($sub_category!=""){
			$post['category_data[0][menu_id]'] = $sub_category;
		}
		$ch = curl_init();
		// Will return the response, if false it print the response
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		// Set the url
		curl_setopt($ch, CURLOPT_URL,"https://www.advice.co.th/product/lazy");
		
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS,$post);

		
		// Execute
		$response = curl_exec($ch);

		
		// close the connection, release resources used
		curl_close($ch);
		return json_decode($response, true);;
	}

	public function getSearchProduct($name){
		
		$ch = curl_init();
		// Will return the response, if false it print the response
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		// Set the url
		curl_setopt($ch, CURLOPT_URL,"https://www.advice.co.th/search?keyword=".$name);
		

		
		// Execute
		$response = curl_exec($ch);

		
		// close the connection, release resources used
		curl_close($ch);
		return $response;
	}
	public function getProductMenu(){
		$sql = "select * from product_type where status = 1" ; 
		$result = $this->conn->query($sql);
		$product_type_array = array();
		while($row = $result->fetch_assoc()) {
			$product_type = new Product_type();

			$product_type->id = $row["id"];
			$product_type->name = $row["type_name"];

			$product_type->category = $this->getProductCategory($product_type->id);

			foreach ($product_type->category as $key => $value) {
				$value->sub_category = $this->getProductSubCategory($value->id);
			}
			
		    array_push($product_type_array, $product_type);
		}
		return $product_type_array;
	}
	public function getProductCategory($pro_id){
		$sql = "select * from product_category where pro_type_id = $pro_id and status = 1 " ; 
		$result = $this->conn->query($sql);
		$product_category_array = array();
		while($row = $result->fetch_assoc()) {
			$product_category = new Product_category();

			$product_category->id = $row["id"];
			$product_category->type_id = $row["pro_type_id"];
			$product_category->category_name = $row["category_name"];
			$product_category->category_val = $row["category_value"];

			
		    array_push($product_category_array, $product_category);
		}
		return $product_category_array;
	}

	public function getProductSubCategory($category_id){
		$sql = "SELECT * FROM product_sub_category WHERE pro_category_id = '$category_id' and status = 1" ; 
		$result = $this->conn->query($sql);
		$product_sub_category_array = array();
		while($row = $result->fetch_assoc()) {
			$product_sub_category = new Product_sub_category();
			$product_sub_category->id = $row["id"];
			$product_sub_category->sub_category_name = $row["pro_sub_category_name"];

			
		    array_push($product_sub_category_array, $product_sub_category);
		}
		return $product_sub_category_array;
	}

	public function getProductList($category,$sub_category){
		$sql = "SELECT * FROM products WHERE pro_category = '$category'" ; 

		if($sub_category != ""){
			$sql = $sql . " and pro_sub_category = '$sub_category'";
		}

		$result = $this->conn->query($sql);
		$products = array();

		$settings = new Settings();

		$setting_mmk = $settings->getMMK();

		while($row = $result->fetch_assoc()) {
			$product = new Product();

			$product->id = $row["id"];
			$product->product_code = $row["pro_code"];
			$product->product_name = $row["pro_name"];
			$product->product_desc = $row["pro_desc"];
			$product->product_price_srp = str_replace(",","",$row["pro_srp"] ) * $setting_mmk->setting_val ;
			$product->product_price_tech = str_replace(",","",$row["pro_technician"] ) * $setting_mmk->setting_val ;
			$product->product_img = $row["pro_img"];
			$product->product_warranty = $row["pro_warranty"];

			
		    array_push($products, $product);
		}

		return $products;
	}

	public function getProductListName($pro_name){
		if(isset($_SESSION['currency'])){
			$currency =$_SESSION['currency'];
		}else{
			$currency = "MMK";
		}
		$settings = new Settings();

		$setting_mmk = $settings->getMMK();

		$res = $this->getSearchProduct($pro_name);
		$dom = new DomDocument('1.0', 'UTF-8');
		@$dom->loadHTML('<?xml version="1.0" encoding="UTF-8"?>' . "\n" .$res);
		$dom->saveXML();
		$xpath  = new DomXPath($dom);

		$product_node = $xpath->query("//div[contains(@class, 'product-column-4')]");

		
		$data = [];
		foreach ($product_node as $key => $value) {
			
			$product = new Product();

			$product->id = $xpath ->query("../..//div[contains(@class, 'item')]/@code-product-item",$value)[0]->value;

			$product->product_code = $xpath ->query("../..//div[contains(@class, 'item')]/@code-product-item",$value)[0]->value;
			
			$product->product_name = $xpath ->query("../..//div[contains(@class, 'item')]/@item-name",$value)[0]->value;
			$product->product_img = $xpath->query("../..//img[contains(@class, 'img-fluid')]/@url-img",$value)[0]->value;
			$product->link = $xpath->query("../..//a/@href",$value)[0]->value;
		  	$product->product_desc = $xpath->query("../..//div[contains(@class, 'item-spec item-spec-font sss')]",$value)[0]->nodeValue;

		  	$product->product_price_srp = $xpath->query("../..//div[contains(@class, 'sale sale-font')]",$value)[0]->nodeValue;
		  	$prict_tech_bode = $xpath->query("../..//div[contains(@class, 'sales-price sales-price-font')]",$value);
		  	if(count($prict_tech_bode) == 0){
		  		$product->product_price_tech = $product->product_price_srp;
		  	}else{
		  		$product->product_price_tech = $prict_tech_bode[0]->nodeValue;
		  	}

		  	$product->product_warranty = $xpath->query("../..//span[contains(@class, 'float-right pr-1 font-arial font-12')]",$value)[0]->nodeValue;
		  	

		  	$product->product_desc = preg_replace('/(\v|\s)+/', '',$product->product_desc);
		  	$product->product_price_tech = str_replace( ',', '', $product->product_price_tech );
		  	$product->product_price_srp = str_replace( ',', '', $product->product_price_srp );

		  	$product->product_price_tech = trim(str_replace( '.-', '', $product->product_price_tech ));
		  	$product->product_price_srp = trim(str_replace( '.-', '', $product->product_price_srp ));
		  	
		  	
			if($currency == "MMK"){
				$product->product_price_tech = $product->product_price_tech * $setting_mmk->setting_val ;
		  	    $product->product_price_srp =  $product->product_price_srp * $setting_mmk->setting_val;
			}
			
			$new_product_price_tech =substr(round($product->product_price_tech,0), 0, -2)."00";
		  	$new_product_price_srp = substr(round($product->product_price_srp,0), 0, -2)."00";
			
			$product->product_price_tech = $new_product_price_tech;
			$product->product_price_srp = $new_product_price_srp;


		  	$product->product_name = str_replace("\\",'',$product->product_name);
		  	$product->product_desc = str_replace("\\",'',$product->product_desc);
		  	$product->product_name = str_replace("'",'',$product->product_name);
		  	$product->product_desc = str_replace("'",'',$product->product_desc);

		  	$product->product_warranty = str_replace("ประกัน",'warranty',$product->product_warranty);
		  	$product->product_warranty = str_replace("ปี",'year',$product->product_warranty);
		    array_push($data, $product);
		   
			
		}

	    return $data;

	   
		// exit();


		// $sql = "SELECT * FROM products WHERE pro_name like '%{$pro_name}%'" ; 

		// $result = $this->conn->query($sql);
		// $products = array();

		// $settings = new Settings();

		// $setting_mmk = $settings->getMMK();

		// while($row = $result->fetch_assoc()) {
		// 	$product = new Product();

		// 	$product->id = $row["id"];
		// 	$product->product_code = $row["pro_code"];
		// 	$product->product_name = $row["pro_name"];
		// 	$product->product_desc = $row["pro_desc"];
		// 	$product->product_price_srp = str_replace(",","",$row["pro_srp"] ) * $setting_mmk->setting_val ;
		// 	$product->product_price_tech = str_replace(",","",$row["pro_technician"] ) * $setting_mmk->setting_val ;
		// 	$product->product_img = $row["pro_img"];
		// 	$product->product_warranty = $row["pro_warranty"];

			
		//     array_push($products, $product);
		// }

		// return $products;
	}

	public function getProduct($id){
		$sql = "SELECT * FROM products WHERE id = '$id'" ; 
		$result = $this->conn->query($sql);
		$product = new Product();

		$settings = new Settings();

		$setting_mmk = $settings->getMMK();
		while($row = $result->fetch_assoc()) {
			$product->id = $row["id"];
			$product->product_code = $row["pro_code"];
			$product->product_name = $row["pro_name"];
			$product->product_desc = $row["pro_desc"];
			$product->product_price =str_replace(",","",$row["pro_technician"] ) * $setting_mmk->setting_val ;
			$product->product_img = $row["pro_img"];
			$product->product_warranty = $row["pro_warranty"];
		}
		return $product;
	}
	public function getProductListFromUrl($category,$sub_category,$skip,$take){
		if(isset($_SESSION['currency'])){
			$currency =$_SESSION['currency'];
		}else{
			$currency = "MMK";
		}
		
		$settings = new Settings();

		$setting_mmk = $settings->getMMK();

		$category = str_replace(' ','-',$category);
		$sub_category = str_replace(' ','-',$sub_category);
		$res_json = $this->getHTML(mb_strtolower($category),mb_strtolower($sub_category),$skip,$take);
		$dom = new DomDocument('1.0', 'UTF-8');
		$data = [];
		$data['next'] = $res_json["next"];
		$data['products'] = [];
		foreach ($res_json["data"] as $key => $value) {
			@$dom->loadHTML('<?xml version="1.0" encoding="UTF-8"?>' . "\n" .$value["product"]);
			$dom->saveXML();
			$xpath  = new DomXPath($dom);

			$product = new Product();

			$product->id =  $xpath ->query("//div[contains(@class, 'item')]/@code-product-item")[0]->value;
			$product->product_code = $xpath ->query("//div[contains(@class, 'item')]/@code-product-item")[0]->value;
			$product->product_name = $xpath ->query("//div[contains(@class, 'item')]/@item-name")[0]->value;
			$product->product_img = $xpath->query("//img[contains(@class, 'img-fluid')]/@url-img")[0]->value;
			$product->link = $xpath->query("//a/@href")[0]->value;
		  	$product->product_desc = $xpath->query("//div[contains(@class, 'item-spec item-spec-font sss')]")[0]->nodeValue;

		  	$product->product_price_srp = $xpath->query("//div[contains(@class, 'sale sale-font')]")[0]->nodeValue;
		  	$prict_tech_bode = $xpath->query("//div[contains(@class, 'sales-price sales-price-font')]");
		  	if(count($prict_tech_bode) == 0){
		  		$product->product_price_tech = $product->product_price_srp;
		  	}else{
		  		$product->product_price_tech = $prict_tech_bode[0]->nodeValue;
		  	}

		  	$node_warranty = $xpath->query("//span[contains(@class, 'float-right pr-1 font-arial font-12')]");

		  	if(isset($node_warranty) and count($node_warranty)>0){
		  		$product->product_warranty = $node_warranty[0]->nodeValue;
		  	}else{
		  		$product->product_warranty = "";
		  	}
		  
		  	

		  	$product->product_desc = preg_replace('/(\v|\s)+/', '',$product->product_desc);
		  	$product->product_price_tech = str_replace( ',', '', $product->product_price_tech );
		  	$product->product_price_srp = str_replace( ',', '', $product->product_price_srp );

		  	$product->product_price_tech = trim(str_replace( '.-', '', $product->product_price_tech ));
		  	$product->product_price_srp = trim(str_replace( '.-', '', $product->product_price_srp ));
		  	
			if($currency == "MMK"){
				$product->product_price_tech = $product->product_price_tech * $setting_mmk->setting_val ;
		  	    $product->product_price_srp =  $product->product_price_srp * $setting_mmk->setting_val;
			}
		  	
			
			$new_product_price_tech =substr(round($product->product_price_tech,0), 0, -2)."00";
		  	$new_product_price_srp = substr(round($product->product_price_srp,0), 0, -2)."00";
			
			$product->product_price_tech = $new_product_price_tech;
			$product->product_price_srp = $new_product_price_srp;
				
				
		  	$product->product_name = str_replace("\\",'',$product->product_name);
		  	$product->product_desc = str_replace("\\",'',$product->product_desc);
		  	$product->product_name = str_replace("'",'',$product->product_name);
		  	$product->product_desc = str_replace("'",'',$product->product_desc);

		  	$product->product_warranty = str_replace("ประกัน",'warranty',$product->product_warranty);
		  	$product->product_warranty = str_replace("ปี",'year',$product->product_warranty);

		    array_push($data['products'], $product);
		   
			
		}
	    return $data;
	}
}


?>